<!-- Main content -->
<x-admin.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:menuOpen>{{ $data['menuOpen'] }} </x-slot:menuOpen>
    <x-slot:menuActive>{{ $data['menuActive'] }} </x-slot:menuActive>
    <x-slot:page>{{ $data['page'] }}</x-slot:page>
    <x-slot:head>
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
        <link rel="stylesheet" href="{{ asset('assets/') }}/admin/plugins/sweetalert2/sweetalert2.min.css">
    </x-slot:head>


    <section class="content">

        <!-- Default box -->
        <div class="row">
            <div class="col-lg-12">
                <x-message></x-message>
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-server text-primary"></i> {{ $data['page'] }}</h3>
                    </div>
                    <div class="card-body">
                        <form class="form-inline float-right">
                            <input class="form-control mr-sm-2" type="search" placeholder="Search" aria-label="Search"
                                name="cari">
                            <button class="btn btn-primary " type="submit"> <i class="fa fa-search mr-2"></i>
                                Cari!</button>
                        </form>

                        <button class="btn btn-default shadow-sm">
                            <div class="icheck-blue d-inline " style="margin-right: -7px">
                                <input type="checkbox" id="cekall">
                                <label for="cekall">
                                </label>
                            </div>
                        </button>
                        <button class="btn btn-danger" id="pilih_hapus"><i class="fa fa-trash"></i> Hapus</button>
                        <table class="table table-bordered table-hover myTable tab mt-2">
                            <thead>
                                <tr>
                                    <th width="3%">No</th>
                                    <th>#</th>
                                    <th>Nama Lengkap</th>
                                    <th>Email</th>
                                    <th>Subjek</th>
                                    <th>Status</th>
                                    <th>Tgl. Kirim</th>
                                    <th width="20%">Opsi</th>
                                </tr>
                            </thead>
                            <tbody id="view">
                                @forelse ($pesan as $p)
                                    <tr>
                                        <td class="text-center">{{ $no++ }}</td>
                                        <td class="text-center">
                                            <div class="icheck-blue d-inline " style="margin-right: -7px">
                                                <input type="checkbox" name="id[]" id="cek{{ $p->id }}"
                                                    class="ceklis" value="{{ $p->id }}">
                                                <label for="cek{{ $p->id }}">
                                                </label>
                                            </div>
                                        </td>
                                        <td>{{ $p->nama }}</td>
                                        <td>{{ $p->email }}</td>
                                        <td>{{ $p->subjek }}</td>
                                        <td>{!! $p->sts_pesan == 'B' ? '<span class="badge badge-danger">Pesan Baru</span>' : 'Dilihat' !!}
                                        </td>
                                        <td>{{ tgl_inf($p->created_at) }} </td>
                                        <td class="text-center">
                                            <button class="btn btn-info btn-sm lihat" data-id="{{ $p->id }}"><i
                                                    class="fa fa-eye mr-2"></i>
                                                Lihat</button>
                                            <button class="btn btn-danger btn-sm hapus" data-id="{{ $p->id }}"
                                                data-nm="{{ $p->nama }}"><i class="fa fa-trash mr-2"></i>
                                                Hapus</button>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="10" class="text-center">Data masih kosong</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
        <!-- /.card -->

    </section>

    {{-- detail member --}}
    <div class="modal fade" id="detail">
        <div class="modal-dialog ">
            <div class="modal-content">
                <div class="modal-header bg-danger ">
                    Detail Pesan
                </div>
                <div class="modal-body" id="vdetail">

                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>


    <x-slot:foot>
        <script src="{{ asset('assets/') }}/admin/plugins/sweetalert2/sweetalert2.all.min.js"></script>
        <script>
            $('#view').on('click', '.lihat', function() {
                var token = $("meta[name='csrf-token']").attr("content");
                var id = $(this).attr('data-id');

                $.ajax({
                    type: 'post',
                    url: 'lihat-pesan',
                    data: {
                        id: id,
                        _token: token,
                    },
                    success: function(data) {
                        $('#detail').modal('show');
                        $('#vdetail').html(data);
                    }
                });
            });
            $('#view').on('click', '.hapus', function() {
                var id = $(this).attr('data-id');
                var nama = $(this).attr('data-nm');

                Swal.fire({
                    title: "Apa anda yakin?",
                    text: "Pesan  dari ( " + nama + " ) akan di hapus!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Ya, Hapus!"
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.location.href = "delete-pesan/" + id;
                    }
                });

            });

            // ceklis
            $("#cekall").change(function() {
                if ($(this).prop("checked")) {
                    $(".ceklis").prop("checked", true);
                } else {
                    $(".ceklis").prop("checked", false);
                }
            });

            $("#pilih_hapus").click(function() {
                var allVals = [];
                $(".ceklis:checked").each(function() {
                    allVals.push($(this).val());
                });
                var token = $("meta[name='csrf-token']").attr("content");

                if (allVals.length <= 0) {
                    Toast.fire({
                        icon: "error",
                        title: "Ceklis data yang akan dihapus!!!.",
                    });
                } else {
                    Swal.fire({
                        title: "Pastikan dengan benar!",
                        text: "Data yang anda pilih akan dihapus!",
                        icon: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#3085d6",
                        cancelButtonColor: "#d33",
                        confirmButtonText: "Ya, Hapus!",
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                type: "DELETE",
                                url: "deleteall-pesan",
                                data: {
                                    allVals: allVals,
                                    _token: token,
                                },
                                beforeSend: function() {
                                    $("#pilih_hapus").html(
                                        '<i class="fas fa-spinner fa-spin"></i> Tunggu..'
                                    );
                                    $("#pilih_hapus").attr("disabled", true);
                                },
                                success: function(data) {
                                    // alert(data)
                                    $("#pilih_hapus").html(
                                        '<i class="fa fa-trash"></i>'
                                    );
                                    $("#pilih_hapus").attr("disabled", true);
                                    Swal.fire({
                                        icon: "success",
                                        title: "Berhasil",
                                        text: "Data berhasil dihapus!",
                                    }).then((result) => {
                                        if (result.isConfirmed) {
                                            document.location.href = "";
                                        }
                                    });
                                },
                            });
                        }
                    });
                }
            });
        </script>
    </x-slot:foot>
</x-admin.contents>
